<?php

namespace Application\Core\Form\Field;

use Pongho\Form\BaseField;

class AccountUrlField extends BaseField
{
    public function isReadonly()
    {
        return true;
    }

    /**
     * @return string
     */
    public function getTag()
    {
        $this->addCssClass('url-editor');

        $url_part = sprintf(
            $this->getSetting('url-path', '') . '<span%s>%s</span>',
            $this->getAttributesCode(),
            html_escape($this->getValue())
        );

        $btn_part = '';
        if (!$this->getSetting('disable-edit', false)) {
            $btn_part = sprintf(
                '<button type="button" id="%s" data-form="%s" title="%s">%s</button>',
                $this->getId() . '-btn',
                $this->getSetting('form-url'),
                $this->getSetting('lightbox-title'),
                $this->getSetting('button-value')
            );
        }

        return $url_part . $btn_part;
    }

    /**
     * Restituisce il valore di default nel caso il campo non sia stato passato nella request perché non selezionato (es checkbox o select multiple)
     *
     * @access public
     * @return mixed
     */
    public function emptyValue()
    {
        return '';
    }

    /**
     * {@inheritdoc}
     */
    public function setBaseAttributes()
    {
        $this->setAttribute('id', $this->getId());

        return $this;
    }

    public function getValidAttributes()
    {
        return array('id', 'class', 'style');
    }
}
