<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Entity;

/**
 * Interface LanguageSiteInterface
 */
interface LanguageSiteInterface
{
    /**
     * @return int
     */
    public function getId();

    /**
     * @return int
     */
    public function getLanguageId();

    /**
     * @return LanguageInterface
     */
    public function getLanguage();

    /**
     * @return int
     */
    public function getSiteId();

    /**
     * @return SiteInterface
     */
    public function getSite();

    /**
     * @return string
     */
    public function getPath();

    /**
     * @return bool
     */
    public function isEnabled();

    /**
     * @return $this
     */
    public function enable();

    /**
     * @return $this
     */
    public function disable();

    /**
     * @param int|ModuleInterface $module
     * @return LanguageModuleInterface
     */
    public function getLanguageModule($module);

    /**
     * @return LanguageModuleInterface[]
     */
    public function getLanguageModules();
}
