<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\Entity;

interface FileInterface
{
    /**
     * Restituisce l’indirizzo del file caricato.
     *
     * Esempio:
     * <code>
     *   echo $file->path(); // http://www.example.com/content/uploads/file.ext
     * </code>
     *
     * @return string
     */
    public function path();

    /**
     * Restituisce il percorso del file su filesystem.
     *
     * Esempio:
     * <code>
     *   echo $file->path(); // /www/virtuali/example.com/content/uploads/file.ext
     * </code>
     *
     * @return string
     */
    public function filepath();

    /**
     * Restituisce la dimensione del file in formato leggibile.
     *
     * Esempio:
     * <code>
     *   echo $file->size(); // 1.2 MB
     * </code>
     *
     * return string
     */
    public function size();
}
