<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author  Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\DependencyInjection;

use Application\Core\Utilities\Shortcode;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

class ShortcodeServiceProvider implements ServiceProviderInterface
{
    /**
     * @var array
     */
    protected static $shared = array();

    /**
     * {@inheritdoc}
     */
    public function register(Container $container)
    {
        $container->setService('shortcode', array($this, 'getShortcodeService'));

        $container->extend(
            'shortcode',
            function (Shortcode $shortcode, Container $container) {
                /** @var $site \Application\Core\Model\Site */
                $site = $container->getService('site');

                /** @var $view \Pongho\Template\Theme */
                $view = $container->getService('theme_view');

                $shortcode
                    ->add('config', function (array $attributes, $content, $tag_name) use ($site) {
                        if (!array_key_exists('key', $attributes)) {
                            return false;
                        }

                        $attribute = substr($attributes['key'], 5);

                        if ($attribute && $site->attributePresent($attribute)) {
                            return $site->$attribute;
                        }

                        return $site->getOption($attributes['key']);
                    })
                    ->add('include', function(array $attributes, $content, $tag_name) use ($view) {
                        if (!array_key_exists('template', $attributes)) {
                            throw new \InvalidArgumentException(sprintf('Parameter "template" is required in %s shortcode!', $tag_name));
                        }

                        // Vista
                        $view->setTemplate("snippets/{$attributes['template']}.php")
                            ->assignVar('attrs', $attributes);

                        return $view->render();
                    });
            }
        );
    }

    /**
     * Restituisce il gestore degli shortcode.
     *
     * @access protected
     * @param Container $container
     * @return \Application\Core\Utilities\Shortcode
     */
    public function getShortcodeService(Container $container)
    {
        if (!array_key_exists('shortcode', self::$shared)) {
            $class = $container->getParameter('shortcode.shortcode_class');

            self::$shared['shortcode'] = new $class();
        }

        return self::$shared['shortcode'];
    }
}
