<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\DependencyInjection;

use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

/**
 * Class FormProvider
 *
 * @todo: Sperimentale
 */
class FormProvider implements ServiceProviderInterface
{
    /**
     * @var array
     */
    protected static $shared = array();

    /**
     * {@inheritdoc}
     */
    public function register(Container $container)
    {
        $container->setService('form_login', array($this, 'getUserLoginFormService'));
        $container->setService('form_subscribe', array($this, 'getUserSubscribeFormService'));
        $container->setService('form_user_settings', array($this, 'getUserSettingsFormService'));
        $container->setService('form_forgot_password', array($this, 'getUserForgotPasswordFormService'));
        $container->setService('form_reset_password', array($this, 'getUserResetPasswordFormService'));
    }

    /**
     * Idea da implementare.
     *
     * @access protected
     * @param Container $container
     * @return \Pongho\Form\Form
     */
    public function getUserLoginFormService(Container $container)
    {
        $class = $container->getParameter('user.login_form_class');

        return $class::create($container->getService('request'));
    }

    /**
     * Idea da implementare.
     *
     * @access protected
     * @param Container $container
     * @return \Pongho\Form\Form
     */
    public function getUserSubscribeFormService(Container $container)
    {
        $class = $container->getParameter('user.subscribe_form_class');

        return $class::create($container->getService('request'));
    }

    /**
     * Idea da implementare.
     *
     * @access protected
     * @param Container $container
     * @return \Pongho\Form\Form
     */
    public function getUserSettingsFormService(Container $container)
    {
        $class = $container->getParameter('user.settings_form_class');

        return $class::create($container->getService('request'));
    }

    /**
     * Idea da implementare.
     *
     * @access protected
     * @param Container $container
     * @return \Pongho\Form\Form
     */
    public function getUserForgotPasswordFormService(Container $container)
    {
        $class = $container->getParameter('user.forgot_password_form_class');

        return $class::create($container->getService('request'));
    }

    /**
     * Idea da implementare.
     *
     * @access protected
     * @param Container $container
     * @return \Pongho\Form\Form
     */
    public function getUserResetPasswordFormService(Container $container)
    {
        $class = $container->getParameter('user.reset_password_form_class');

        return $class::create($container->getService('request'));
    }
}
