<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\DependencyInjection;

use Application\Core\Utilities\AdminUserNotificationHelper;
use Application\Core\Utilities\UserActivationLinkBuilder;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

/**
 * CoreServiceProvider
 */
class CoreServiceProvider implements ServiceProviderInterface
{
    /**
     * @var array
     */
    protected static $sharedServices = array();

    /**
     * {@inheritdoc}
     */
    public function register(Container $container)
    {
        $container->setService('user_activation_link_builder', array($this, 'getUserActivationLinkBuilder'));
        $container->setService('admin_user_notification_helper', array($this, 'getAdminUserNotificationHelper'));
    }

    /**
     * @return UserActivationLinkBuilder
     */
    public function getUserActivationLinkBuilder()
    {
        if (!array_key_exists('user_activation_link_builder', static::$sharedServices)) {
            static::$sharedServices['user_activation_link_builder'] = new UserActivationLinkBuilder();
        }

        return static::$sharedServices['user_activation_link_builder'];
    }

    /**
     * @param Container $container
     * @return AdminUserNotificationHelper
     */
    public function getAdminUserNotificationHelper(Container $container)
    {
        if (!array_key_exists('admin_user_notification_helper', static::$sharedServices)) {
            static::$sharedServices['admin_user_notification_helper'] = new AdminUserNotificationHelper(
                $container->getService('notification_sender'),
                $container->getService('notification_collection'),
                $container->getService('user_activation_link_builder')
            );
        }

        return static::$sharedServices['admin_user_notification_helper'];
    }
}
