<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\DependencyInjection;

use Application\Core\Command\CacheClearCommand;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

/**
 * Class ConsoleCommandProvider
 */
class ConsoleCommandProvider implements ServiceProviderInterface
{
    /**
     * {@inheritdoc}
     */
    public function register(Container $container)
    {
        $container->extend(
            'console_commands',
            function (\ArrayObject $commands, Container $container) {
                $commands->append(new CacheClearCommand($container->getService('cache')));
            }
        );
    }
}
