<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\DependencyInjection;

use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

class CachingServiceProvider implements ServiceProviderInterface
{
    protected static $shared = array();

    /**
     * {@inheritdoc}
     */
    public function register(Container $container)
    {
        $container->setService('cache', array($this, 'getCacheService'));
    }

    /**
     * Restituisce il gestore della cache.
     *
     * @param Container $container
     * @return \Application\Core\Utilities\Shortcode
     */
    public function getCacheService(Container $container)
    {
        if (!$container->getParameter('cache.enabled')) {
            throw new \BadMethodCallException('Cache disabled!');
        }

        if (!array_key_exists('cache', self::$shared)) {
            $class = $container->getParameter('cache.cache_class');

            if ($class === null || !class_exists($class)) {
                if (function_exists('apc_exists')) {
                    self::$shared['cache'] = new \Pongho\Caching\ApcCache('pongho');
                } elseif (function_exists('xcache_isset')) {
                    self::$shared['cache'] = new \Pongho\Caching\XcacheCache('pongho');
                } else {
                    self::$shared['cache'] = new \Pongho\Caching\FileCache('pongho', CACHE_PATH);
                }
            } else {
                self::$shared['cache'] = new $class();
            }
        }

        return self::$shared['cache'];
    }
}
