<?php

/**
 * Questo file è parte di Pongho (Dev).
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\DependencyInjection;

use Application\Core\Application\Facade;
use Application\Core\Application\Finder;
use Application\Core\Application\Loader;
use Application\Core\Command\ApplicationDisableCommand;
use Application\Core\Command\ApplicationEnableCommand;
use Application\Core\Command\ApplicationInstallCommand;
use Application\Core\Command\ApplicationUninstallCommand;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

/**
 * ApplicationServiceProvider
 */
class ApplicationServiceProvider implements ServiceProviderInterface
{
    /**
     * {@inheritdoc}
     */
    public function register(Container $container)
    {
        $container->setService(
            'application_loader',
            function(Container $container) {
                return new Loader($container->getService('application_manager'), $container);
            }
        );

        $container->setService(
            'application_finder',
            function(Container $container) {
                return new Finder();
            }
        );

        $container->setService(
            'application_facade',
            function(Container $container) {
                return new Facade(
                    $container->getService('application_manager'),
                    $container->getService('application_loader'),
                    $container->getService('application_finder'),
                    $container->getService('translator')
                );
            }
        );

        $container->extend(
            'console_commands',
            function (\ArrayObject $commands, Container $container) {
                $commands->append(new ApplicationInstallCommand($container->getService('application_facade')));
                $commands->append(new ApplicationEnableCommand($container->getService('application_facade')));
                $commands->append(new ApplicationDisableCommand($container->getService('application_facade')));
                $commands->append(new ApplicationUninstallCommand($container->getService('application_facade')));
            }
        );
    }
}
