<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\DependencyInjection;

use Application\Admin\AdminBar\AdminBarBuilder;
use Application\Core\AdminBar\Filler\CoreUserImpersonationFiller;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

/**
 * Class AdminBarServiceProvider
 */
class AdminBarServiceProvider implements ServiceProviderInterface
{
    protected static $shared = array();

    /**
     * {@inheritdoc}
     */
    public function register(Container $container)
    {
        $container->setService('admin_bar_core_entity_filler', array($this, 'getUserImpersonationFillerService'));

        $container->extend(
            'admin_bar_builder',
            function (AdminBarBuilder $builder, Container $container) {
                $builder->add($container->getService('admin_bar_core_entity_filler'));
            }
        );
    }

    /**
     * @param Container $container
     * @return CoreUserImpersonationFiller
     */
    public function getUserImpersonationFillerService(Container $container)
    {
        if (!array_key_exists('admin_bar_cms_entity_filler', static::$shared)) {
            $filler = new CoreUserImpersonationFiller(
                $container->getService('firewall'),
                $container->getService('site'),
                $container->getService('translator')
            );

            static::$shared['admin_bar_cms_entity_filler'] = $filler;
        }

        return static::$shared['admin_bar_cms_entity_filler'];
    }
}
