<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\DependencyInjection;

use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

/**
 * Class AddressProvider
 *
 * Provider per la generazione e la validazione degli indirizzi I18n
 */
class AddressProvider implements ServiceProviderInterface
{
    /**
     * @var array
     */
    protected static $shared = array();

    /**
     * {@inheritdoc}
     */
    public function register(Container $container)
    {
        $container->setService('italy_address_validator', array($this, 'getItalyAddressValidatorService'));
        $container->setService('italy_address_renderer', array($this, 'getItalyAddressRendererService'));
    }

    /**
     * getItalyAddressValidatorService
     *
     * @param Container $container
     * @return \Application\Core\I18n\Country\Italy\AddressValidator
     */
    public function getItalyAddressValidatorService(Container $container)
    {
        if (!array_key_exists('italy_address_validator', self::$shared)) {
            if ($container->hasParameter('italy_address_validator_class')) {
                $class = $container->getParameter('italy_address_validator_class');
            } else {
                $class = 'Application\\Core\\I18n\\Country\\Italy\\AddressValidator';
            }

            self::$shared['italy_address_validator'] = new $class();
        }

        return self::$shared['italy_address_validator'];
    }

    /**
     * getItalyAddressRendererService
     *
     * @param Container $container
     * @return \Application\Core\I18n\Country\Italy\AddressRenderer
     */
    public function getItalyAddressRendererService(Container $container)
    {
        if (!array_key_exists('italy_address_renderer', self::$shared)) {
            if ($container->hasParameter('italy_address_renderer_class')) {
                $class = $container->getParameter('italy_address_renderer_class');
            } else {
                $class = 'Application\\Core\\I18n\\Country\\Italy\\AddressRenderer';
            }

            self::$shared['italy_address_renderer'] = new $class();
        }

        return self::$shared['italy_address_renderer'];
    }
}
