<?php

namespace Application\Core\Dashboard\Widget;

use Application\Admin\Widget\Stats\StatInterface;
use Pongho\DependencyInjection\Container;

class UserStats implements StatInterface
{
	protected $container;
	protected $values;

    /**
     * @param Container $container
     * @param           $values
     */
    public function __construct(Container $container, $values)
	{
		$this->container = $container;
		$this->values = $values;
	}

    /**
     * {@inheritdoc}
     */
    public function render()
	{
        /** @var \Application\Core\I18n\Translator\Translator $translator */
        $translator = $this->container->getService('translator');

		$html = <<<HTML
<div id="statsreport-users" class="statsreport-table">
	<h4>{$translator->trans('Users')}</h4>
	<table>
		<tr>
			<th>{$translator->trans('Role')}</th><th class="statsreport-count">{$translator->trans('Count')}</th>
		</tr>
HTML;

		foreach ( $this->values as $role )
		{
			$html .= <<<HTML
		<tr>
			<td>{$role->name}</td>
			<td>{$role->accounts}</td>
		</tr>
HTML;
		}

		return $html .= '</table></div>';
	}
}
