<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Controller\Admin;

use Application\Admin\Controller\AdminController;
use Application\Core\Model\Language;
use Application\Core\Model\LanguageSite;

/**
 * Class LanguagesController
 */
class LanguagesController extends AdminController
{
    /**
     * Lingue abilitate per il sito
     */
    public function indexAction()
    {
        $site_id = $this->getSiteId();
        $path = $this->getParameter('path');

        /** @var \Pongho\Http\Request $request */
        $request = $this->container->getService('request');

        if ($request->post->has('languages')) {
            foreach ($request->post->get('languages') as $id => $language) {
                $attributes = array();
                foreach ($language as $field => $value) {
                    $attributes[$field] = $value;
                }

                // È necessario specificare la lingua per salvare, se ho sbagliato e non voglio inserirla lascio il campo vuoto per saltarlo
                if (!isset($attributes['language_id']) || empty($attributes['language_id'])) {
                    continue;
                }

                if (!isset($attributes['is_enabled'])) {
                    $attributes['is_enabled'] = false;
                }

                $attributes['site_id'] = $site_id;

                if (is_numeric($id)) {
                    $model = LanguageSite::findByLanguageAndSite($attributes['language_id'], $site_id);

                    $model->updateAttributes($attributes);
                    $model->save();
                } else {
                    LanguageSite::create($attributes);
                }
            }
        }

        $rows = LanguageSite::findAllBySite($this->getSiteId());
        foreach ($rows as $row) {
            $enabled_languages[] = $row->language_id;
        }

        $options = array();
        if (!empty($enabled_languages)) {
            $options = Language::addCondition($options, array('id NOT IN (' . implode(',', $enabled_languages) . ')'));
        }

        $available_languages = array();
        foreach (Language::all($options) as $language) {
            /** @var \Application\Core\Model\Language $language */
            $available_languages[$language->id] = $language->name;
        }

        $this->getHelper()->getHead()
            ->addCss(pongho_url('/Application/Admin/Resources/views/css/style-legacy.css?v=' . filemtime(PONGHO_PATH . '/Application/Admin/Resources/views/css/style-legacy.css')));

        $this->getHelper()->getBodyView()
            ->setTemplatePath(PONGHO_PATH . '/Application/Core/Resources/views/languages_sites.php')
            ->assignVars(
                array(
                    'action_form' => $this->url("/{$path}/"),
                    'rows'        => $rows,
                    'languages'   => $available_languages,
                )
            );

        $this->displayTabs();
    }

    /**
     * Lingue installate
     */
    public function installedAction()
    {
        $path = $this->getParameter('path');

        /** @var \Pongho\Http\Request $request */
        $request = $this->container->getService('request');

        if ($request->post->has('languages')) {
            foreach ($request->post->get('languages') as $language_id => $language) {
                $attributes = array();
                foreach ($language as $field => $value) {
                    $attributes[$field] = $value;
                }

                // È necessario specificare un nome per la lingua per salvare, se ho sbagliato e non voglio inserirla lascio il campo vuoto per saltarlo
                if (!isset($attributes['name']) || empty($attributes['name'])) continue;

                if (is_numeric($language_id)) {
                    $model = Language::find($language_id);

                    $model->updateAttributes($attributes);
                    $model->save();
                } else {
                    Language::create($attributes);
                }
            }
        }

        $rows = Language::all();

        $this->getHelper()->getHead()
            ->addCss(pongho_url('/Application/Admin/Resources/views/css/style-legacy.css?v=' . filemtime(PONGHO_PATH . '/Application/Admin/Resources/views/css/style-legacy.css')));

        $this->getHelper()->getBodyView()
            ->setTemplatePath(PONGHO_PATH . '/Application/Core/Resources/views/languages_installed.php')
            ->assignVars(
                array(
                    'action_form' => $this->url("/{$path}/installed/"),
                    'rows'        => $rows,
                )
            );

        $this->displayTabs();
    }

    /**
     * @return array
     */
    protected function getTabs()
    {
        /** @var \Application\Core\I18n\Translator\Translator $translator */
        $translator = $this->getContainer()->getService('translator');

        $path = $this->getParameter('path');

        return array(
            (object)array(
                'name'      => $translator->trans('Enabled languages'),
                'link'      => $this->url("/{$path}/"),
                'is_active' => ($this->getAction() == 'index')
            ),
            (object)array(
                'name'      => $translator->trans('Installed languages'),
                'link'      => $this->url("/{$path}/installed/"),
                'is_active' => ($this->getAction() == 'installed')
            ),
        );
    }

    /**
     * Visualizza le tabs con le varie categorie di opzione
     *
     * @access protected
     */
    protected function displayTabs()
    {
        $this->getHelper()->getBodyView()
            ->assignVar('tabs', $this->getTabs());
    }
}
