<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele De Nobili
 * @package Application\Core
 */

namespace Application\Core;

use Pongho\Core\Container as ContainerBase;
use Pongho\DependencyInjection\Exception\DeprecatedServiceException;

/**
 * Contenitore delle dipendenze.
 */
class Container extends ContainerBase
{
    /**
     * Restituisce l'istanza del convertitore HTML2PDF
     *
     * @return \HTML2PDF
     * @throws DeprecatedServiceException
     * @deprecated
     */
    protected function getHtml2PdfService()
    {
        /** @var \Pongho\Core\Kernel $kernel */
        $kernel = $this->getService('kernel');

        if ($kernel->isDebug()) {
            throw new DeprecatedServiceException('html2pdf');
        }

        if (!array_key_exists('html2pdf', self::$shared)) {
            self::$shared['html2pdf'] = new \HTML2PDF();
        }

        return self::$shared['html2pdf'];
    }
}
