<?php
/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package @todo
 */

namespace Application\Core\Command;

use Application\Core\Installer\KernelInstaller;
use Doctrine\DBAL\Connection;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class PonghoInstallCommand extends Command
{
    /**
     * @var Connection
     */
    protected $connection;

    /**
     * @param Connection $connection
     */
    public function __construct(Connection $connection)
    {
        $this->connection = $connection;

        parent::__construct();
    }


    /**
     * {@inheritdoc}
     */
    protected function configure()
    {
        $this
            ->setName('pongho:install')
            ->setDefinition(
                array(
                    new InputArgument('domain', InputArgument::REQUIRED, 'The domain for the site being installed'),
                )
            )
            ->setDescription('Installs Pongho');
    }

    /**
     * {@inheritdoc}
     */
    public function execute(InputInterface $input, OutputInterface $output)
    {
        $domain = $input->getArgument('domain');

        $installer = new KernelInstaller($this->connection, $domain);

        $installer->install();
    }
}
