<?php
/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\Command;

use Pongho\Caching\AbstractCache;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
/**
 * Class CacheClearCommand
 */
class CacheClearCommand extends Command
{
    /**
     * @var AbstractCache
     */
    protected $cache;

    /**
     * @param AbstractCache $cache
     */
    public function __construct(AbstractCache $cache)
    {
        $this->cache = $cache;

        parent::__construct();
    }

    /**
     * {@inheritdoc}
     */
    public function configure()
    {
        $this
            ->setName('cache:clear')
            ->setDescription('Clears the site cache');
    }

    /**
     * {@inheritdoc}
     */
    public function execute(InputInterface $input, OutputInterface $output)
    {
        $this->cache->deleteAll();

        $output->writeln('Cache cleared');
    }
}
