<?php

/**
 * Questo file è parte di Pongho (Dev).
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Command;

use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * ApplicationUninstallCommand
 */
class ApplicationUninstallCommand extends AbstractApplicationCommand
{
    /**
     * {@inheritdoc}
     */
    protected function configure()
    {
        $this
            ->setName('application:uninstall')
            ->setDefinition(
                array(
                    new InputArgument(
                        'application',
                        InputArgument::REQUIRED,
                        'The name of the application being uninstalled'
                    ),
                )
            )
            ->setDescription('Uninstalls an application');
    }

    /**
     * {@inheritdoc}
     */
    public function execute(InputInterface $input, OutputInterface $output)
    {
        $this->facade->uninstall($input->getArgument('application'));
    }
}
