<?php

/**
 * Questo file è parte di Pongho (Dev).
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Command;

use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * ApplicationInstallCommand
 */
class ApplicationInstallCommand extends AbstractApplicationCommand
{
    /**
     * {@inheritdoc}
     */
    protected function configure()
    {
        $this
            ->setName('application:install')
            ->setDefinition(
                array(
                    new InputArgument(
                        'application',
                        InputArgument::REQUIRED,
                        'The name of the application being installed'
                    ),
                )
            )
            ->setDescription('Installs an application');
    }

    /**
     * {@inheritdoc}
     */
    public function execute(InputInterface $input, OutputInterface $output)
    {
        $application = $input->getArgument('application');

        if ($application === 'Core' || $application === 'Admin') {
            throw new \OutOfBoundsException(
                'To install applications "Core" or "Admin" you have to run `install pongho:install` from the root of the site.'
            );
        }

        $this->facade->install($application);
    }
}
