<?php

/**
 * Questo file è parte di Pongho (Dev).
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Command;

use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * ApplicationEnableCommand
 */
class ApplicationEnableCommand extends AbstractApplicationCommand
{
    /**
     * {@inheritdoc}
     */
    protected function configure()
    {
        $this
            ->setName('application:enable')
            ->setDefinition(
                array(
                    new InputArgument(
                        'application',
                        InputArgument::REQUIRED,
                        'The name of the application being enabled'
                    ),
                )
            )
            ->setDescription('Enables an application');
    }

    /**
     * {@inheritdoc}
     */
    public function execute(InputInterface $input, OutputInterface $output)
    {
        $this->facade->enable($input->getArgument('application'));
    }
}
