<?php

/**
 * Questo file è parte di Pongho (Dev).
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Command;

use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * ApplicationDisableCommand
 */
class ApplicationDisableCommand extends AbstractApplicationCommand
{
    /**
     * {@inheritdoc}
     */
    protected function configure()
    {
        $this
            ->setName('application:disable')
            ->setDefinition(
                array(
                    new InputArgument(
                        'application',
                        InputArgument::REQUIRED,
                        'The name of the application being disabled'
                    ),
                )
            )
            ->setDescription('Disables an application');
    }

    /**
     * {@inheritdoc}
     */
    public function execute(InputInterface $input, OutputInterface $output)
    {
        $this->facade->disable($input->getArgument('application'));
    }
}
