<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author  Daniele De Nobili
 * @package Application\Core
 */

namespace Application\Core;

use ActiveRecord\Errors;
use Pongho\Core\Controller;
use Pongho\Http\JsonResponse;
use Pongho\Http\RedirectResponse;

/**
 * Controller base.
 *
 * Rappresenta un primo livello da estendere per i vari controller delle applicazioni.
 *
 * @method Utilities\ControllerHelper getHelper()
 */
abstract class BaseController extends Controller
{
    /**
     * Resituisce il modello del sito corrente.
     *
     * @return \Application\Core\Model\Site
     *
     * @deprecated
     */
    public function getSite()
    {
        return $this->getHelper()->getSite();
    }

    /**
     * Restituisce l’ID del sito corrente.
     *
     * @return integer
     */
    public function getSiteId()
    {
        return $this->getHelper()->getSite()->id;
    }

    /**
     * Restituisce il modulo legato al sito.
     *
     * @param boolean $thrown_exception
     * @return \Application\Core\Model\ModuleSite
     *
     * @deprecated
     */
    public function getSiteModule($thrown_exception = true)
    {
        return $this->getHelper()->getModuleSite($thrown_exception);
    }

    /**
     * Restituisce l’ID del modulo legato al sito.
     *
     * @return integer
     */
    public function getSiteModuleId()
    {
        return $this->getHelper()->getModuleSite()->id;
    }

    /**
     * Restituisce l’utente.
     *
     * @return \Application\Core\User
     *
     * @deprecated
     */
    public function getUser()
    {
        return $this->getHelper()->getUser();
    }

    /**
     * Restituisce la sessione.
     *
     * @return \Pongho\Http\Session
     */
    public function getSession()
    {
        return $this->getContainer()->getService('session');
    }

    /**
     * Restituisce la localizzazione.
     *
     * @return \Application\Core\Localization
     *
     * @deprecated Use the helper, Luke
     */
    public function getLocalization()
    {
        return $this->getHelper()->getLocalization();
    }

    /**
     * Restituisce la lingua.
     *
     * @return \Application\Core\Localization
     *
     * @deprecated Usare getLocalization().
     */
    public function getLang()
    {
        return $this->getLocalization();
    }

    /**
     * Restituisce il modello della lingua.
     *
     * @return \Application\Core\Model\LanguageSite
     *
     * @deprecated Use the helper, Luke
     */
    public function getLanguage()
    {
        return $this->getHelper()->getLanguage();
    }

    /**
     * Restituisce il formato iso della lingua.
     *
     * @return string
     */
    public function getLanguageIso()
    {
        return $this->getHelper()->getLanguage()->iso;
    }

    /**
     * Restituisce l’ID della lingua (language_id).
     *
     * @return integer
     */
    public function getLanguageId()
    {
        return $this->getHelper()->getLanguage()->language_id;
    }

    /**
     * Restituisce il path della lingua (language_path).
     *
     * @return integer
     */
    public function getLanguagePath()
    {
        return $this->getHelper()->getLanguage()->path;
    }

    /**
     * Restituisce la vista.
     *
     * @return \Pongho\Template\HeadHelper
     *
     * @deprecated
     */
    public function getHead()
    {
        return $this->getHelper()->getHead();
    }

    /**
     * Visualizza un messaggio.
     *
     * @param string  $message
     * @param boolean $is_error
     * @param array   $parameters
     * @return \Pongho\Core\TemplateResponse|\Pongho\Http\JsonResponse
     *
     * @deprecated
     */
    public function displayMessage($message, $is_error = false, array $parameters = array())
    {
        return $this->getHelper()->displayMessage($message, $is_error, $parameters);
    }

    /**
     * Visualizza un messaggio in formato JSON.
     *
     * @param string  $message
     * @param boolean $is_error
     * @param array   $parameters
     * @return \Pongho\Http\JsonResponse
     *
     * @deprecated
     */
    public function displayJsonMessage($message, $is_error = false, array $parameters = array())
    {
        return $this->getHelper()->displayJsonMessage($message, $is_error, $parameters);
    }

    /**
     * Visualizza un messaggio di errore.
     *
     * @param string $message
     * @param array  $parameters
     * @return \Pongho\Http\JsonResponse
     *
     * @deprecated
     */
    public function displayError($message, array $parameters = array())
    {
        return $this->getHelper()->displayMessage($message, true, $parameters);
    }

    /**
     * Visualizza un messaggio di errore in formato JSON.
     *
     * @param string $message
     * @param array  $parameters
     * @return \Pongho\Http\JsonResponse
     *
     * @deprecated
     */
    public function displayJsonError($message, array $parameters = array())
    {
        return $this->getHelper()->displayJsonMessage($message, true, $parameters);
    }

    /**
     * Restituisce una risposta per un redirect all’url passato.
     *
     * Questo metodo tiene conto anche delle richieste AJAX.
     *
     * @param string $redirect_url
     * @return JsonResponse|RedirectResponse
     *
     * @deprecated
     */
    public function redirectResponse($redirect_url)
    {
        return $this->getHelper()->redirectResponse($redirect_url);
    }

    /**
     * Elabora gli errori generati da un modello per ottenere la versione tradotta.
     *
     * @param \ActiveRecord\Errors $model_errors
     * @return array
     */
    protected function translateErrors(Errors $model_errors)
    {
        $errors = array();
        foreach ($model_errors->all_as_hash() as $field => $error) {
            $errors[$field] = $this->getHelper()->getLocalization()->get($error);
        }

        return $errors;
    }
}
