<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\Application;

class Finder implements FinderInterface
{
    public function find()
    {
        $kernels_path = PONGHO_PATH . '/Application/*/Kernel.php';
        $base_path_length = strlen(PONGHO_PATH) + 1;

        $apps = array();

        foreach (glob($kernels_path) as $kernel_file) {
            $kernel_class = str_replace('/', '\\', substr($kernel_file, $base_path_length, -4));

            $segments = explode('\\', $kernel_class);
            $apps[] = $segments[1];
        }

        return $apps;
    }
}
