<?php

/**
 * Created by PhpStorm.
 * User: Wolfolo
 * Date: 18/04/2015
 * Time: 10:21
 */
namespace Application\Core\AdminBar\Filler;

use Application\Admin\AdminBar\AdminBar;
use Application\Admin\AdminBar\FillerInterface;
use Application\Core\Entity\SiteInterface;
use Application\Core\Firewall;
use Application\Core\I18n\Translator\Translator;
use Pongho\Menu\Item;
use Pongho\Menu\Menu;

/**
 * Class CoreEntityFiller
 */
class CoreUserImpersonationFiller implements FillerInterface
{
    /**
     * @type Translator
     */
    protected $translator;

    /**
     * @type Firewall
     */
    protected $firewall;

    /**
     * @var SiteInterface
     */
    protected $site;

    /**
     * @param Firewall      $firewall
     * @param SiteInterface $site
     * @param Translator    $translator
     */
    public function __construct(Firewall $firewall, SiteInterface $site, Translator $translator)
    {
        $this->translator = $translator;
        $this->firewall = $firewall;
        $this->site = $site;
    }

    /**
     * {@inheritdoc}
     */
    public function fill(AdminBar $admin_bar)
    {
        $user = $this->firewall->getCurrentUser();
        $real_user = $this->firewall->getRealUser();

        // si potrebbe evitare facendo fare il controllo al firewall e utilizzare una funzione apposita
        if ($user->getAccount()->getId() === $real_user->getAccount()->getId()) {
            return;
        }

        $menu = new Menu(
            $this->translator->trans(
                'Browsing as <strong>%name%</strong>',
                array('%name%' => $user->getAccount()->name())
            )
        );

        $menu->setId('pongho-user-impersonation');

        $menu->add(
            new Item(
                $this->translator->trans('User profile'),
                pongho_url('/users/edit/' . $user->getAccount()->getId() . '/?stop_impersonation&site=' . $this->site->getId())
            )
        );

        $menu->add(
            new Item(
                $this->translator->trans('Exit impersonation'),
                '?stop_impersonation'
            )
        );

        $admin_bar->right->add($menu, -1);
    }
}
