<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Utilities;

/**
 * Class MailerHelper
 *
 * @deprecated Usare Core\Mailer\MailerHelper
 */
class MailerHelper
{
    /**
     * @var Mailer
     */
    protected $mailer;

    /**
     * @param Mailer $mailer
     */
    public function __construct(Mailer $mailer)
    {
        $this->mailer = $mailer;
    }

    /**
     * Restituisce un array di email per il Mailer::send() in base alla configurazione passata.
     *
     * Esempi:
     * <code>
     *      Se $email è: 'email@example.com'
     *      Risulta in: array('email@example.com')
     * </code>
     * Oppure in formato RFC 2822
     * <code>
     *      Se $email è: 'Name <email@example.com>'
     *      Risulta in: array('email@example.com' => 'Name')
     * </code>
     * Con variabili a sostituzione:
     * <code>
     *      Se $email è: '%NAME% <%EMAIL%>' e $vars è: array('NAME' => 'name', 'EMAIL' => 'email@example.com')
     *      Risulta in: array('email@example.com' => 'Name')
     * </code>
     * Sono possibili configurazioni miste quali:
     * <code>
     *      $email: 'foo@acme.com, %NAME1% <%EMAIL1%>, %NAME2% <%EMAIL2%>, %EMAIL3%'
     * </code>
     *
     * @param string $email
     * @param array  $vars
     * @return array
     */
    public function parseEmails($email, array $vars = array())
    {
        if (!is_hash($vars)) {
            throw new \InvalidArgumentException('The "vars" array MUST be a hash');
        }

        $keys = array_map(
            function ($value) {
                return strtoupper("%{$value}%");
            },
            array_keys($vars)
        );

        $values = array_map(
            function ($value) {
                if (is_array($value)) {
                    return '';
                }

                return htmlspecialchars($value);
            },
            array_values($vars)
        );

        $parsed = str_replace($keys, $values, $email);
        $parsed = $this->mailer->parse($parsed, $vars);

        return $this->getEmailAddresses($parsed);
    }

    /**
     * Estrae gli indirizzi email da una stringa che può contenerne vari in diverse varianti, separati da virgola.
     *
     * Esempi:
     * <code>
     *      Se $addresses è: 'foo@bar.com, bar baz <bar@baz.it>,boo<boo@boo.net>'
     *      Risulta in: array('foo@bar.com', 'bar@baz.it' => 'bar baz', 'boo@boo.net' => 'boo')
     * </code>
     *
     * @param string $addresses
     * @return array
     */
    public function getEmailAddresses($addresses)
    {
        preg_match_all('/([[:alnum:]@\-\.]+)([ ]?<(.*?[^>]*)>)?/', $addresses, $matches, PREG_SET_ORDER);

        $recipients = array();
        foreach ($matches as $address) {
            if (isset($address[3])) {
                $recipients[trim($address[3])] = trim($address[1]);
            } else {
                $recipients[] = trim($address[1]);
            }
        }

        return $recipients;
    }
}
