<?php
/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\Updates;

use Doctrine\DBAL\Schema\Schema;
use Updates\SchemaUpdate;

/**
 * Class Update86
 */
class Update86 extends SchemaUpdate
{
    /**
     * {@inheritdoc}
     */
    protected function prepareSchema(Schema $schema)
    {
        $table = $schema->createTable('pongho_apps_sites');
        $table->addColumn('app_id', 'integer', array('unsigned' => true));
        $table->addColumn('site_id', 'integer', array('unsigned' => true));
        $table->addForeignKeyConstraint($schema->getTable('pongho_apps'), array('app_id'), array('id'));
        $table->addForeignKeyConstraint($schema->getTable('pongho_sites'), array('site_id'), array('id'));
    }
}
