<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Application\Core\Model\Translation;
use Updates\BaseUpdate;

/**
 * Update146
 *
 * Aggiunge le traduzioni per la barra della privacy policy
 */
class Update146 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        Translation::putTranslation('cookiebar_modaltext', 'Proseguendo la navigazione presti il tuo consenso all’installazione dei cookie.', 'theme', 'it_IT');
        Translation::putTranslation('cookiebar_modalbutton', 'Prosegui la navigazione', 'theme', 'it_IT');
        Translation::putTranslation('cookiebar_accept', 'OK', 'theme', 'it_IT');
        Translation::putTranslation('cookiebar_content', 'Questo sito web utilizza i cookie e consente l’invio di cookie di terze parti. Premendo il tasto OK o compiendo una qualunque azione all’interno del sito web accetterai l’utilizzo dei cookie. Per saperne di più su come modificare o negare l’utilizzo dei cookie consulta la nostra:', 'theme', 'it_IT');
        Translation::putTranslation('cookiebar_legalnotice', 'Privacy policy', 'theme', 'it_IT');
        Translation::putTranslation('cookiebar_link', 'https://www.iubenda.com/privacy-policy/######', 'theme', 'it_IT');
    }
}
