<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Doctrine\DBAL\Schema\Schema;
use Updates\SchemaUpdate;

/**
 * Class Update142
 */
class Update142 extends SchemaUpdate
{
    /**
     * prepareSchema
     *
     * @param \Doctrine\DBAL\Schema\Schema $schema
     */
    protected function prepareSchema(Schema $schema)
    {
        $table = $schema->getTable('pongho_regions');

        if (!$table->hasColumn('country_id')) {
            $table->addColumn('country_id', 'integer', array('unsigned' => true, 'notnull' => false, 'default' => null));
        }
    }
}
