<?php
/**
 * @var \Application\Core\I18n\Translation\Translator $translator
 * @var \Pongho\Template\Html                        $html
 * @var array                                        $translations
 * @var array                                        $applications
 */
?>

<?php if (!empty($translations)): foreach ($translations as $key => $data): ?>
    <dl class="extend">
        <dt><code class="key"><?php echo $key, '<select name="translations[', $key, '][application]" style="display: block; width: 200px;">', $html->select($applications, $data['application']), '</select>'; ?></code></dt>
        <?php $first = true;
        foreach ($data['translations'] as $language_site_id => $translation): ?>
            <dd class="large">
                <?php
                echo $translation['flag'];
                $value = $translation['value'];
                printf(
                    '<input type="text" class="input_text" name="translations[%s][translations][%s]" value="%s">',
                    $key,
                    $translation['language_site_id'],
                    htmlspecialchars($translation['value'], ENT_QUOTES, 'UTF-8')
                );

                if ($first) {
                    $first = false;

                    printf(
                        '<label><input type="checkbox" name="translations[%s][delete]" />%s</label>',
                        $key,
                        $translator->trans('Delete')
                    );
                } ?>
            </dd>
        <?php endforeach; ?>
    </dl>
<?php endforeach;
else: ?>
    <p class="empty"><?php echo $translator->trans('The search did not found any translation.'); ?></p>
<?php endif; ?>
