/**
 * firstUserInteraction.js
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 */

/*jslint nomen: true, plusplus: true, passfail: true, browser: true, devel: true */

(function (d, w) {
    "use strict";

    var listeners = [], dispatched = false;

    // Nome del cookie per la privacy
    w.ponghoCookiePrivacy = 'pongho_privacy';

    w.onFirstUserInteraction = function (callback) {
        if (w.cookieManager.read(w.ponghoCookiePrivacy)) {
            callback();
        } else {
            listeners.push(callback);
        }
    };

    function dispatch() {
        if (dispatched) {
            return;
        }

        w.cookieManager.create(w.ponghoCookiePrivacy, 1, 365);

        var l = listeners.length, i, callback;

        for (i = 0; i < l; i++) {
            callback = listeners[i];
            callback();
        }

        dispatched = true;
    }

    if (w.cookieManager.read(w.ponghoCookiePrivacy)) {
        return;
    }

    if (d.addEventListener) {
        d.addEventListener('click', function (event) {
            if (event.target.id !== 'cookiebar__link') {
                dispatch();
            }
        }, true);

        d.addEventListener('scroll', dispatch, true);
    } else if (d.attachEvent) {
        d.attachEvent('onclick', function (event) {
            if (event.srcElement.id !== 'cookiebar__link') {
                dispatch();
            }
        });

        w.attachEvent('onscroll', dispatch);
    }
}(document, window));
