<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Notification\Exception;

/**
 * SendException
 */
class SendException extends \Exception
{
    /**
     * @var string
     */
    protected $send_type;

    /**
     * @param string     $message
     * @param string     $send_type
     * @param \Exception $prev_exception
     */
    public function __construct($message, $send_type, \Exception $prev_exception = null)
    {
        parent::__construct($message, 0, $prev_exception);

        $this->send_type = $send_type;
    }

    /**
     * @return string
     */
    public function getSendType()
    {
        return $this->send_type;
    }
}
