<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model;

use ActiveRecord\Base;
use Application\Core\Entity\ProvinceInterface;
use Application\Core\Entity\RegionInterface;
use Application\Core\Model\Manager\RegionManager;
use Pongho\Core\Kernel;

/**
 * Modello per le province.
 *
 * @property int    $id
 * @property int    $region_id
 * @property string $name
 * @property string $plate
 */
class Province extends Base implements ProvinceInterface
{
    /**
     * Nome della tabella.
     *
     * @static
     * @var string
     */
    public static $table_name = 'provinces';

    /**
     * Restituisce l’elenco delle province di una regione.
     *
     * @param int $region_id
     * @return Province[]
     * @static
     */
    public static function findAllByRegion($region_id)
    {
        return self::all(
            array(
                'conditions' => array('region_id = ?', $region_id),
                'order'      => 'name'
            )
        );
    }

    /**
     * Restituisce una provincia in base alla targa.
     *
     * @param string $plate
     * @return Province
     * @static
     */
    public static function findByPlate($plate)
    {
        return self::first(
            array(
                'conditions' => array('plate = ?', $plate),
            )
        );
    }

    /**
     * __toString
     *
     * @return string
     */
    public function __toString()
    {
        return $this->name;
    }

    /**
     * @deprecated
     */
    public static function all_by_region($region_id)
    {
        return self::findAllByRegion($region_id);
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getPlate()
    {
        return $this->plate;
    }

    /**
     * @return RegionInterface
     */
    public function getRegion()
    {
        /** @var RegionManager $manager */
        $manager = Kernel::instance()->getContainer()->get('region_manager');

        return $manager->findById($this->region_id);
    }

    /**
     * @return int
     */
    public function getRegionId()
    {
        return $this->region_id;
    }
}
