<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model;

use ActiveRecord\Base;

/**
 * Modello per le relazioni tra permessi e ruoli.
 *
 * @property int $permit_id
 * @property int $role_id
 */
class PermitRole extends Base
{
    /**
     * Nome della tabella.
     *
     * @static
     * @var string
     */
    public static $table_name = 'permits_roles';

    /**
     * Chiave primaria.
     *
     * @static
     * @var string|array
     */
    public static $primary_key = array('permit_id', 'role_id');
}
