<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model\Manager;

use Application\Core\Model\Region;

/**
 * Class RegionManager
 */
class RegionManager implements RegionManagerInterface
{
    /**
     * @var Region[]
     */
    protected $models;

    /**
     * @param int $id
     * @return Region
     */
    public function findById($id)
    {
        $this->prepare();

        if (array_key_exists($id, $this->models)) {
            return $this->models[$id];
        }

        return null;
    }

    /**
     * @return Region[]
     */
    public function findAll()
    {
        $this->prepare();

        return $this->models;
    }

    /**
     * Precarica le regioni
     */
    protected function prepare()
    {
        if ($this->models === null) {
            $this->models = array();

            /** @var Region $region */
            foreach (Region::all() as $region) {
                $this->models[$region->getId()] = $region;
            }
        }
    }
}
