<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model\Manager;

use Application\Core\Entity\ProvinceInterface;
use Application\Core\Entity\RegionInterface;

/**
 * Interface ProvinceManagerInterface
 */
interface ProvinceManagerInterface
{
    /**
     * @param int $id
     * @return ProvinceInterface
     */
    public function findById($id);

    /**
     * @param string $plate
     * @return ProvinceInterface
     */
    public function findByPlate($plate);

    /**
     * @return ProvinceInterface[]
     */
    public function findAll();

    /**
     * @param int|RegionInterface $region
     * @return ProvinceInterface[]
     */
    public function findByRegion($region);
}
