<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\Model\Manager;

use Application\Core\Entity\LinkTypeInterface;
use Application\Core\Model\LinkType;

class LinkTypeManager implements LinkTypeManagerInterface
{
    /**
     * @var array
     */
    protected $link_types = array();

    /**
     * {@inheritdoc}
     */
    public function findById($id)
    {
        if (!array_key_exists($id, $this->link_types)) {
            $this->link_types[$id] = LinkType::find($id);
        }

        return $this->link_types[$id];
    }

    /**
     * @return LinkTypeInterface
     */
    public function newModel()
    {
        return new LinkType();
    }

    /**
     * {@inheritdoc}
     */
    public function delete(LinkTypeInterface $link_type)
    {
        /** @var \ActiveRecord\Base $link_type */
        return $link_type->delete();
    }

    /**
     * {@inheritdoc}
     */
    public function save(LinkTypeInterface $link_type)
    {
        /** @var \ActiveRecord\Base $link_type */
        return $link_type->save();
    }

    /**
     * Trova il LinkType usando lingua, modello e tipo
     *
     * @static
     * @param integer $language_id
     * @param integer $model_id
     * @param string  $link_type
     * @return \Application\Core\Entity\LinkTypeInterface[]
     */
    public function allByLanguageAndModelIdAndLinkType($language_id, $model_id, $link_type)
    {
        $link_types = LinkType::all(
            array(
                'conditions' => array(
                    'language_id = :language_id AND model_id = :model AND link_type = :link_type',
                    'language_id' => $language_id,
                    'model'       => $model_id,
                    'link_type'   => $link_type
                ),
            )
        );

        /** @var LinkTypeInterface $model */
        foreach ($link_types as $model) {
            if (!array_key_exists($model->getId(), $this->link_types)) {
                $this->link_types[$model->getId()] = $model;
            }
        }

        return $link_types;
    }
}
