<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model\Manager;

use Application\Core\Entity\LanguageInterface;
use Application\Core\Entity\LanguageSiteInterface;
use Application\Core\Entity\SiteInterface;

/**
 * Interface LanguageSiteManagerInterface
 */
interface LanguageSiteManagerInterface
{
    /**
     * @param $language_site_id
     * @return LanguageSiteInterface
     */
    public function findById($language_site_id);

    /**
     * @param $language_id
     * @param $site_id
     * @return LanguageSiteInterface
     */
    public function findByLanguageAndSite($language_id, $site_id);

    /**
     * @return LanguageSiteInterface[]
     */
    public function findAll();

    /**
     * @param $site_id
     * @return LanguageSiteInterface[]
     */
    public function findAllBySite($site_id);

    /**
     * @param LanguageSiteInterface $language_site
     * @return bool
     */
    public function save(LanguageSiteInterface $language_site);

    /**
     * @param int|LanguageInterface $language
     * @param int|SiteInterface     $site
     * @param string                $path
     * @param bool                  $is_enabled
     * @return LanguageSiteInterface
     */
    public function create($language, $site, $path, $is_enabled = true);

    /**
     * @param LanguageSiteInterface $language_site
     * @return mixed
     */
    public function enable(LanguageSiteInterface $language_site);

    /**
     * @param LanguageSiteInterface $language_site
     * @return mixed
     */
    public function disable(LanguageSiteInterface $language_site);

}
