<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model\Manager;

use Application\Core\Entity\LanguageModuleInterface;
use Application\Core\Entity\LanguageSiteInterface;
use Application\Core\Entity\ModuleInterface;

/**
 * Interface LanguageModuleManagerInterface
 */
interface LanguageModuleManagerInterface
{
    /**
     * Ricerca in base a `language_site_id` e `module_id`.
     *
     * @param integer $language_site_id
     * @param integer $module_id
     * @return LanguageModuleInterface
     */
    public function findByLanguageSiteAndModule($language_site_id, $module_id);

    /**
     * Ricerca in base a `language_id` e `site_module_id`.
     *
     * @param integer $language_id
     * @param integer $site_module_id
     * @return LanguageModuleInterface
     */
    public function findByLanguageAndModuleSite($language_id, $site_module_id);

    /**
     * Ricerca in base a `language_id`, `site_id` e `module_id`.
     *
     * @param integer $language_id
     * @param integer $site_id
     * @param integer $module_id
     * @return LanguageModuleInterface
     */
    public function findByLanguageAndSiteAndModule($language_id, $site_id, $module_id);

    /**
     * @return LanguageModuleInterface[]
     */
    public function findAll();

    /**
     * @param int $module_site_id
     * @return LanguageModuleInterface[]
     */
    public function findAllByModuleSite($module_site_id);

    /**
     * @param int $site_id
     * @return LanguageModuleInterface[]
     */
    public function findAllBySite($site_id);

    /**
     * @param int $module_id
     * @return LanguageModuleInterface[]
     */
    public function findAllByModule($module_id);

    /**
     * @param int $language_id
     * @return LanguageModuleInterface[]
     */
    public function findAllByLanguage($language_id);

    /**
     * @param int $language_site_id
     * @return LanguageModuleInterface[]
     */
    public function findAllByLanguageSite($language_site_id);

    /**
     * Ricerca tutti in base a `module_id` e `site_id`.
     *
     * @param $site_id
     * @param $module_id
     * @return \Application\Core\Entity\LanguageModuleInterface[]
     */
    public function findAllBySiteAndModule($site_id, $module_id);

    /**
     * @param int|LanguageSiteInterface $language_site
     * @param int|ModuleInterface       $module
     * @param string                    $path
     * @param string                    $name
     * @param integer                   $position
     * @param boolean                   $is_enabled
     * @return LanguageModuleInterface
     */
    public function create($language_site, $module, $path, $name, $position, $is_enabled = true);

    /**
     * @param LanguageModuleInterface $language_module
     * @return $this
     */
    public function save(LanguageModuleInterface $language_module);
}
