<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author  Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\Model\Manager;

use Application\Core\Entity\SiteInterface;

/**
 * Interface ApplicationManagerInterface
 */
interface ApplicationManagerInterface
{
    /**
     * @param int|SiteInterface $site
     * @return \Application\Core\Entity\ApplicationInterface[]
     */
    public function allEnabled($site);

    /**
     * @return \Application\Core\Entity\ApplicationInterface[]
     */
    public function allInstalled();

    /**
     * @param string $app_name
     * @return bool
     */
    public function isInstalled($app_name);

    /**
     * @param string            $app_name
     * @param int|SiteInterface $site
     * @return bool
     */
    public function isEnabled($app_name, $site);

    /**
     * @param string $app_name
     * @return bool
     */
    public function isEnabledInAnySite($app_name);

    /**
     * @param string $app_name
     */
    public function createApplication($app_name);

    /**
     * @param string $app_name
     */
    public function deleteApplication($app_name);

    /**
     * @param string            $app_name
     * @param int|SiteInterface $site
     */
    public function createApplicationSite($app_name, $site);

    /**
     * @param string            $app_name
     * @param int|SiteInterface $site
     */
    public function deleteApplicationSite($app_name, $site);

    /**
     * @param string $app_name
     * @return \Application\Core\Entity\ApplicationInterface|null
     */
    public function findByAppName($app_name);
}
