<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model;

use ActiveRecord\Base;

/**
 * AccountPortfolio.
 *
 * Questo modello è legato alla tabella `users_relations` e serve come supporto al modello `Account` per la gestione
 * della portafogliazione. Rappresenta una qualsiasi relazione tra antenato e discendente, indipendentemente dal loro
 * livello di parentela.
 *
 * @property int $id
 * @property int $relation_id
 * @property int $ancestor_id
 * @property int $descendant_id
 * @property int $depth
 */
class AccountPortfolio extends Base
{
    /**
     * Nome della tabella.
     *
     * @static
     * @var string
     */
    public static $table_name = 'users_portfolio';
}
