<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\LinkType;

use Application\Core\Entity\LinkTypeInterface;

/**
 * Interface ResourceInterface
 */
interface ResourceInterface
{
    /**
     * @param LinkTypeInterface $link_type
     * @return string
     */
    public function getTitle(LinkTypeInterface $link_type);

    /**
     * @param LinkTypeInterface $link_type
     * @return string
     */
    public function getPermalink(LinkTypeInterface $link_type);

    /**
     * @param LinkTypeInterface $link_type
     * @return mixed
     */
    public function getResource(LinkTypeInterface $link_type);

    /**
     * @param LinkTypeInterface $link_type
     */
    public function updateCache(LinkTypeInterface $link_type);
}
