<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\LinkType\Resource;

use Application\Cms\Model\Menu;
use Application\Cms\Model\MenuItem;
use Application\Core\Entity\LinkTypeInterface;
use Application\Core\LinkType\ResourceInterface;
use Application\Core\Model\LanguageModule;

/**
 * Class ModuleResource
 */
class ModuleResource implements ResourceInterface
{
    /**
     * @var LanguageModule[][]
     */
    protected $models = array();

    /**
     * @var int
     */
    protected $site_id;

    /**
     * @param int $site_id
     */
    function __construct($site_id)
    {
        $this->site_id = $site_id;
    }

    /**
     * {@inheritdoc}
     */
    public function getTitle(LinkTypeInterface $link_type)
    {
        $resource = $this->getResource($link_type);

        if ($resource) {
            return $resource->name;

        }

        return '';
    }

    /**
     * {@inheritdoc}
     */
    public function getPermalink(LinkTypeInterface $link_type)
    {
        $resource = $this->getResource($link_type);

        if ($resource) {
            return absolute_url($resource->path);
        }

        return '';
    }

    /**
     * {@inheritdoc}
     */
    public function getResource(LinkTypeInterface $link_type)
    {
        $model_id = $link_type->getLinkDetails()->getModelId();
        $language_id = $link_type->getLinkDetails()->getLanguageId();

        if (!(array_key_exists($model_id, $this->models) && array_key_exists($language_id, $this->models[$model_id]))) {
            $this->models[$model_id][$language_id] = LanguageModule::findByLanguageAndSiteAndModule($language_id, $this->site_id, $model_id);
        }

        return $this->models[$model_id][$language_id];
    }

    /**
     * {@inheritdoc}
     */
    public function updateCache(LinkTypeInterface $link_type)
    {
        $options = array(
            'select'     => '`from`.*',
            'joins'      => 'INNER JOIN ' . MenuItem::tableName() . ' AS mi ON mi.menu_id = `from`.id',
            'conditions' => array(
                'mi.link_type_id = :item AND mi.language_id = :language',
                'item'     => $link_type->getId(),
                'language' => $link_type->getLinkDetails()->getLanguageId()
            ),
        );

        if (($menu = Menu::first($options)) !== null) {
            $menu->emptyCache();
        }
    }
}
