<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\LinkType;

class LinkHandlerCollectionFactory
{
    /**
     * @var callable[]
     */
    protected $collections = array();

    /**
     * @param string   $name
     * @param callable $callable
     * @param array    $args
     */
    public function register($name, callable $callable, array $args = array())
    {
        $this->collections[$name] = array($callable, $args);
    }

    /**
     * @param string $name
     * @param int    $language_id
     * @return LinkHandlerCollection
     */
    public function create($name, $language_id)
    {
        if (isset($this->collections[$name])) {
            $callback = $this->collections[$name][0];
            $args = $this->collections[$name][1];

            array_unshift($args, $name);
            array_unshift($args, $language_id);

            return call_user_func_array($callback, $args);
        }

        throw new \InvalidArgumentException('The collection "' . $name . '" does not exist');
    }
}
