/*
TEST:
***************************************
SELECT 1 AS o, date_format('2012-01-01 13:45:23.999', '%a %b %c %D %d %e %f %H %h %I %i %j %k %l %M %m %p %r %S %s %T %U %u %V %v %W %w %X %x %Y %y %%')
UNION
SELECT 2 AS o, date_format('2012-12-31 11:45:23.999', '%a %b %c %D %d %e %f %H %h %I %i %j %k %l %M %m %p %r %S %s %T %U %u %V %v %W %w %X %x %Y %y %%')
UNION
SELECT 3 AS o, date_format('2013-01-01 10:45:23.999', '%a %b %c %D %d %e %f %H %h %I %i %j %k %l %M %m %p %r %S %s %T %U %u %V %v %W %w %X %x %Y %y %%')
ORDER BY o
***************************************
MySQL Result
***************************************
1 | Sun Jan 1 1st 01 1 999000 13 01 01 45 001 13 1 January 01 PM 01:45:23 PM 23 23 13:45:23 01 00 01 52 Sunday 0 2012 2011 2012 12 %
2 | Mon Dec 12 31st 31 31 999000 11 11 11 45 366 11 11 December 12 AM 11:45:23 AM 23 23 11:45:23 53 53 53 01 Monday 1 2012 2013 2012 12 %
3 | Tue Jan 1 1st 01 1 999000 10 10 10 45 001 10 10 January 01 AM 10:45:23 AM 23 23 10:45:23 00 01 53 01 Tuesday 2 2012 2013 2013 13 %
***************************************
*/

CREATE OR REPLACE FUNCTION date_format(_timestamp timestamp with time zone, _format varchar) RETURNS text AS $$
DECLARE
	token varchar[];
	map varchar[] := ARRAY[
		['%a', 'Dy'],		-- Abbreviated weekday name (Sun..Sat)
		['%b', 'Mon'],		-- Abbreviated month name (Jan..Dec)
		['%c', 'FMMM'],		-- Month, numeric (0..12)
		['%D', 'FMDDth'],	-- Day of the month with English suffix (0th, 1st, 2nd, 3rd, …)
		['%d', 'DD'],		-- Day of the month, numeric (00..31)
		['%e', 'FMDD'],		-- Day of the month, numeric (0..31)
		['%f', 'US'],		-- Microseconds (000000..999999)
		['%H', 'HH24'],		-- Hour (00..23)
		['%h', 'HH'],		-- Hour (01..12)
		['%I', 'HH12'],		-- Hour (01..12)
		['%i', 'MI'],		-- Minutes, numeric (00..59)
		['%j', 'DDD'],		-- Day of year (001..366)
		['%k', 'FMHH24'],	-- Hour (0..23)
		['%l', 'FMHH12'],	-- Hour (1..12)
		['%M', 'FMMonth'],	-- Month name (January..December)
		['%m', 'MM'],		-- Month, numeric (00..12)
		['%p', 'AM'],		-- AM or PM
		['%r', 'HH:MI:SS AM'],	-- Time, 12-hour (hh:mm:ss followed by AM or PM)
		['%S', 'SS'],		-- Seconds (00..59)
		['%s', 'SS'],		-- Seconds (00..59)
		['%T', 'HH24:MI:SS'],	-- Time, 24-hour (hh:mm:ss)
/* sbaglia */	['%U', '[WW]'],		-- Week (00..53), where Sunday is the first day of the week
/* sbaglia */	['%u', '[WW]'],		-- Week (00..53), where Monday is the first day of the week
/* sbaglia */	['%V', '[IW]'],		-- Week (01..53), where Sunday is the first day of the week; used with %X
/* forse */	['%v', 'IW'],		-- Week (01..53), where Monday is the first day of the week; used with %x
		['%W', 'FMDay'],	-- Weekday name (Sunday..Saturday)
/* sbaglia */	['%w', '[D]'],		-- Day of the week (0=Sunday..6=Saturday); in pgsql sono 1..7
/* sbaglia */	['%X', '[IYYY]'],	-- Year for the week where Sunday is the first day of the week, numeric, four digits; used with %V
/* forse */	['%x', 'IYYY'],		-- Year for the week, where Monday is the first day of the week, numeric, four digits; used with %v
		['%Y', 'YYYY'],		-- Year, numeric, four digits
		['%y', 'YY'],		-- Year, numeric (two digits)
		['%%', '%']		-- A literal “%” character
	];
BEGIN
	FOREACH token SLICE 1 IN ARRAY map LOOP
		--RAISE NOTICE '%', 'REPLACE(''' || _format || ''', ' || token[1] || ', ' || token[2] || ')';
		SELECT REPLACE(_format, token[1], token[2]) INTO _format;
	END LOOP;

	RETURN to_char(_timestamp, _format);
END;
$$ LANGUAGE plpgsql;