<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Installer\Helper;

use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Schema\Comparator;
use Doctrine\DBAL\Schema\Schema;

/**
 * DatabaseSchemaHelper
 */
class DatabaseSchemaHelper
{
    /**
     * @var Connection
     */
    protected $connection;

    /**
     * @var Schema
     */
    protected $schema;

    /**
     * @param Connection $connection
     */
    public function __construct(Connection $connection)
    {
        $this->connection = $connection;
    }

    /**
     * @return Schema
     */
    public function get()
    {
        if ($this->schema === null) {
            $this->schema = $this->connection->getSchemaManager()->createSchema();
        }

        return $this->schema;
    }

    /**
     * @param callable $callable
     * @return bool
     * @throws \Doctrine\DBAL\DBALException
     */
    public function update(callable $callable)
    {
        $schema = $this->get();
        $new_schema = clone $schema;

        call_user_func($callable, $new_schema);

        $diff = (new Comparator())->compare($schema, $new_schema);
        $platform = $this->connection->getDatabasePlatform();

        foreach ($diff->toSql($platform) as $query) {
            $this->connection->exec($query);
        }

        return true;
    }
}
