<?php

namespace Application\Core\Form\Field;

use Application\Core\Model\Province;
use Pongho\Form\Field\SelectField;

class ProvinceField extends SelectField
{
    protected $value_type = 'id';

    /**
     * Imposta il tipo di valore da utilizzare per la select delle province
     *
     * @access public
     * @param string $value_type //[id|name|plate]
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setValueType($value_type)
    {
        if (!in_array($value_type, array('id', 'name', 'plate'))) {
            throw new \InvalidArgumentException(sprintf('Value type "%s" is not valid', $value_type));
        }

        $this->value_type = $value_type;

        return $this;
    }

    /**
     * Restituisce il tipo di valore utilizzato per la select delle province
     *
     * @access public
     * @return string
     */
    public function getValueType()
    {
        return $this->value_type;
    }

    /**
     * Imposta le opzioni della select
     *
     * @access public
     * @throws \BadMethodCallException
     */
    public function setOptions($options)
    {
        throw new \BadMethodCallException('You could\'t override the provinces!');
    }

    /**
     * Restituisce le opzioni della select
     *
     * @access public
     * @return array
     */
    public function getOptions()
    {
        if (empty($this->options)) {
            foreach (Province::all(array('order' => 'name')) as $province) {
                $this->options[$province->{$this->value_type}] = $province->name;
            }
        }

        return $this->options;
    }
}
