<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Entity;

/**
 * Interface LanguageModuleInterface
 */
interface LanguageModuleInterface
{
    /**
     * @return int
     */
    public function getModuleId();

    /**
     * @return ModuleInterface
     */
    public function getModule();

    /**
     * @return int
     */
    public function getLanguageSiteId();

    /**
     * @return LanguageSiteInterface
     */
    public function getLanguageSite();

    /**
     * @return string
     */
    public function getPath();

    /**
     * @return string
     */
    public function getName();

    /**
     * @return int
     */
    public function getPosition();

    /**
     * @return bool
     */
    public function isEnabled();

    /**
     * @return $this
     */
    public function enable();

    /**
     * @return $this
     */
    public function disable();

    /**
     * @return LanguageInterface
     */
    public function getLanguage();

    /**
     * @return SiteInterface
     */
    public function getSite();

    /**
     * @return ModuleSiteInterface
     */
    public function getModuleSite();
}
