<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Entity;

/**
 * FileInterface
 */
interface ImageInterface extends FileInterface
{
    /**
     * Restituisce il nome dell’immagine comprensivo della taglia per la visualizzazione delle miniature.
     *
     * Esempio:
     * <code>
     *   echo $image->addSize('foo'); // example-foo.jpg
     * </code>
     *
     * @param string $size Il nome della taglia da inserire.
     * @return string Il nome del file completo di taglia
     *
     * @deprecated
     */
    public function addSize($size);

    /**
     * Restituisce l’URL dell’immagine aggiungendo il nome della taglia per la visualizzazione delle miniature.
     *
     * Esempio:
     * <code>
     *   echo $image->addSize('foo'); // http://example.com/images/example-foo.jpg
     * </code>
     *
     * @param string $size
     * @return string
     */
    public function getSizePermalink($size = null);
}
