<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Entity;

/**
 * Interface FileInterface
 */
interface FileInterface
{
    /**
     * @return int
     */
    public function getId();

    /**
     * Restituisce il nome del file
     *
     * @return string
     */
    public function getName();

    /**
     * Restituisce il MIME Type del file
     *
     * @return string
     */
    public function getMimeType();

    /**
     * Restituisce il nome del file completo di estensione
     *
     * @return string
     */
    public function getCompleteFileName();

    /**
     * Restituisce l’indirizzo del file caricato.
     *
     * Esempio:
     * <code>
     *   echo $file->path(); // http://www.example.com/content/uploads/file.ext
     * </code>
     *
     * @return string
     */
    public function path();

    /**
     * Restituisce il percorso del file su filesystem.
     *
     * Esempio:
     * <code>
     *   echo $file->path(); // /www/virtuali/example.com/content/uploads/file.ext
     * </code>
     *
     * @return string
     */
    public function filepath();

    /**
     * Restituisce la dimensione del file in formato leggibile.
     *
     * Esempio:
     * <code>
     *   echo $file->size(); // 1.2 MB
     * </code>
     *
     * return string
     */
    public function size();
}
