<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\DependencyInjection;

use Application\Core\User;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;
use Pongho\Http\Session;

/**
 * Class UserServiceProvider
 */
class UserServiceProvider implements ServiceProviderInterface
{
    /**
     * {@inheritdoc}
     */
    public function register(Container $container)
    {
        $container->share('session', array($this, 'getSessionService'));
        $container->share('current_user', array($this, 'getCurrentUserService'));
    }

    /**
     * Restituisce l’utente corrente.
     *
     * @param Container $container
     * @return User
     *
     * @internal
     */
    public function getCurrentUserService(Container $container)
    {
        return new User(
            $container->get('session')
        );
    }

    /**
     * Restituisce la sessione.
     *
     * @param Container $container
     * @return Session
     * @internal
     */
    public function getSessionService(Container $container)
    {
        $session = new Session();

        $session->start([
            'name'            => $container->getParameter('session_name', 'pongho'),
            'cookie_lifetime' => $container->getParameter('session_lifetime', 0)
        ]);

        return $session;
    }
}
