<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\DependencyInjection;

use Application\Core\Utilities\AccountInfoRenderer;
use Application\Core\Utilities\AdminUserNotificationHelper;
use Application\Core\Utilities\UserActivationLinkBuilder;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

/**
 * CoreServiceProvider
 */
class CoreServiceProvider implements ServiceProviderInterface
{
    /**
     * {@inheritdoc}
     */
    public function register(Container $container)
    {
        $container->share('user_activation_link_builder', array($this, 'getUserActivationLinkBuilder'));
        $container->share('admin_user_notification_helper', array($this, 'getAdminUserNotificationHelper'));
        $container->share('account_info_renderer', array($this, 'getAccountInfoRendererService'));
    }

    /**
     * @return UserActivationLinkBuilder
     *
     * @internal
     */
    public function getUserActivationLinkBuilder()
    {
        return new UserActivationLinkBuilder();
    }

    /**
     * @param Container $container
     * @return AdminUserNotificationHelper
     *
     * @internal
     */
    public function getAdminUserNotificationHelper(Container $container)
    {
        return new AdminUserNotificationHelper(
            $container->get('notification_sender'),
            $container->get('notification_collection'),
            $container->get('user_activation_link_builder')
        );
    }

    /**
     * @param Container $container
     * @return AccountInfoRenderer
     *
     * @internal
     */
    public function getAccountInfoRendererService(Container $container)
    {
        return new AccountInfoRenderer($container->get('translator'));
    }
}
